/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.security.*;

import com.sapportals.wcm.util.acl.*;

import java.util.*;

/**
 * An IAclSecurityManager is a ISecurityManager which uses Access Control Lists
 * - the IAclSecurityManager maps IActions passed to isAllowed()
 * (ISecurityManager) to IPermissions passed to checkPermission() (IResourceAcl)
 * - IActions are only mapped to atomic IPermissions
 */
public interface IAclSecurityManager extends ISecurityManager {
  /**
   * get the IResourceAclManager which administers and persists the Access
   * Control Lists
   *
   * @return the IResourceAclManager
   */
  public IResourceAclManager getAclManager();
}
