/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.util.uri.RID;

/**
 * An {@link IAclInheritanceController} administers the inheritance of ACLs.
 * <p>
 * Copyright (c) SAP AG 2002-2004
 * @author martin.boettcher@greenbytes.de
 */
public interface IAclInheritanceController {
  /**
   * Returns the legator of a resource given by its {@link RID}. If the resource
   * shouldn't inherit its ACLs a <code>null</code> is returned.
   *
   * @param currentResource the resource
   * @param context to operate in
   * @return the {@link RID} of the legator or <code>null</code>
   */
  public RID getLegator(RID currentResource, IResourceContext context)
    throws ResourceException;

}
