/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.util.events.AbstractEventMapper;
import com.sapportals.wcm.util.events.EventList;
import com.sapportals.wcm.util.events.IEvent;
import com.sapportals.wcm.util.events.IEventList;
import com.sapportals.wcm.util.events.IEventListIterator;
import java.util.ArrayList;

import java.util.Properties;

/**
 * A base class to derive resource event mapper implementations. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/manager/AbstractResourceEventMapper.java#7
 *      $
 * @review-reader Hansi Richstein
 * @review-date 09.01.2002
 */
public abstract class AbstractResourceEventMapper
   extends AbstractEventMapper
   implements IResourceEventMapper {

  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  /**
   * Create a mapper with a specific id from the given properties.
   *
   * @param id TBD: Description of the incoming method parameter
   * @param properties TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  protected AbstractResourceEventMapper(String id, Properties properties)
    throws WcmException {

    super(id, properties);

  }


  // --------------------
  // IResourceEventMapper -----------------------------------------------------
  // --------------------

  public IEvent map(IEvent event) {

    if (!(event instanceof IResourceEvent)) {
      return null;
    }

    return map((IResourceEvent)event);
  }


  public abstract IResourceEvent map(IResourceEvent event);


  public IEventList getEvents(IResourceEventBroker broker,
    IResource resource) {

    IEventList events = new EventList();

    if (broker == null) {
      return events;
    }

    IEventList brokerEvents = broker.getEvents(resource);
    ArrayList types = new ArrayList(brokerEvents.size());
    IEventListIterator brokerEventIterator = brokerEvents.listIterator();
    while (brokerEventIterator.hasNext()) {
      IResourceEvent event = (IResourceEvent)brokerEventIterator.next();
      event = new ResourceEvent(resource, event.getType());
      IEvent mappedEvent = map(event);
      if ((mappedEvent != null)
         && (!types.contains(new Integer(mappedEvent.getType())))
        ) {
        types.add(new Integer(mappedEvent.getType()));
        events.addLast(mappedEvent);
      }
    }

    return events;
  }

}
