/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.util.uri.URI;

/**
 * A URI filter manager implements the behaviour for filtering URIs. It can
 * decide whether to apply a filter and will create the appropriate filter
 * objects and initialize them with the URI to filter.
 *
 * @version $Revision:$
 * @deprecated As of EP 5.0 SP5, replaced by {@link IRidFilterManager}
 */
public interface IUriFilterManager extends IFilterManager {

  /**
   * Returns a filter object that should be applied to the URI. Returns <code>
   * null</code> if no filter should be applied th the URI.
   *
   * @param uri The URI to process
   * @param context The resource context
   * @return The filter object
   * @exception WcmException
   */
  public IUriFilter getFilter(URI uri, IResourceContext context)
    throws WcmException;
}
