/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.util.uri.RID;

/**
 * The RID filter manager must decide whether to apply a filter and create the
 * appropriate filter objects and initialize them with the RID to process and
 * any other parameters it needs. The framework will call the getFilter() method
 * for RIDs that have a "~alias~" prefix.
 *
 * @version $Revision:$
 */
public interface IRidFilterManager extends IFilterManager {

  /**
   * Returns a filter object that will be used to process the RID or <code>null
   * </code>.
   *
   * @param rid The RID to process
   * @param context The resource context
   * @return The filter object
   * @exception WcmException
   */
  public IRidFilter getFilter(RID rid, IResourceContext context)
    throws WcmException;
}
