/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.util.uri.RID;

/**
 * A RID filter object is created by a {@link IRidFilterManager} and is
 * responsible for processing a RID. For example a filter can modify the
 * original RID, modify the {@link IResourceContext} or access other CM
 * components. A filter should not modify the resource referenced by the RID or
 * any of its parent collections in the Repository Manager.
 */
public interface IRidFilter extends IFilter {

  /**
   * Returns the resulting RID (can be the unchanged original RID).
   *
   * @return the resulting RID (can be the unchanged original RID).
   * @exception WcmException
   */
  public RID filter()
    throws WcmException;

}
