/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IPropertyMap;
import com.sapportals.wcm.repository.IResource;

/**
 * A property filter manager implements the behaviour for applying property
 * filters. It can decide whether to apply a filter an will create the
 * apropriate filter objects and initialize them with the content to filter.
 *
 * @version $Revision:$
 */
public interface IPropertyFilterManager extends IFilterManager {

  /**
   * Returns a read filter object that should be applied to the property map of
   * the predecessor filter. If the manager decides not to apply a filter he
   * must return the reference to the predecessor filter. It should not return
   * null here, but instead throw an exception if something went wrong.
   * Returning null or throwing an exception will stop the filtering process.
   *
   * @param propFilter The predecessor filter in the cascade
   * @return The filter object
   * @exception WcmException
   */
  public IPropertyFilter getFilterForRead(IPropertyFilter propFilter)
    throws WcmException;


  /**
   * Returns a write filter objects
   *
   * @param propFilter The predecessor filter in the cascade
   * @return The filter object
   * @exception WcmException Exception raised in failure situation
   */
  public IPropertyFilter getFilterForWrite(IPropertyFilter propFilter)
    throws WcmException;
}
