/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IPropertyMap;
import com.sapportals.wcm.repository.IPropertyNameList;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.enum.PropertyFilterMode;
import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.util.uri.URI;
import java.util.Properties;

/**
 * Property filters are used to manipulate resource properties and their
 * visibility. They can modify, delete or add properties to a resource. <p>
 *
 * For example, with the help of a filter it is possible to change the property
 * that specifies the author of resource. The personal name of the author can be
 * changed to the company name.
 *
 * @author SAP AG
 * @version $Revision:$
 */
public interface IPropertyFilter extends IFilter {

  /**
   * @return filterContext
   * @todo: Description of the Method.
   * @todo: Description of the outgoing return value
   */
  Properties getFilterContext();


  /**
   * Returns the resource that will be filtered. Will return null if a property
   * write filter is applied to a create operation.
   *
   * @return The resource
   * @exception WcmException
   */
  IResource getResource()
    throws WcmException;


  /**
   * Returns the URI of the new resource in case the property write filter is
   * applied to a create operation.
   *
   * @return The URI
   * @exception WcmException
   */
  URI getURI()
    throws WcmException;


  /**
   * Returns the repository manager of the new resource in case the write filter
   * is applied to a create operation.
   *
   * @return A reference to a repository manager instance
   * @exception WcmException
   */
  public IRepositoryManager getRepositoryManager()
    throws WcmException;


  /**
   * Get the FilterMode attribute of the IPropertyFilter object.
   *
   * @return The FilterMode value
   * @exception WcmException Exception raised in failure situation
   */
  public PropertyFilterMode getFilterMode()
    throws WcmException;


  /**
   * Get the property name list if mode is SINGLE_PROPERTY or PROPERTY_LIST.
   *
   * @return The FilterMode value
   * @exception WcmException Exception raised in failure situation
   */
  public IPropertyNameList getPropertyNameList()
    throws WcmException;


  /**
   * Returns the filtered property map. A filter implementation must never
   * return <code>null</code> or a new empty map. If the filter will not change the map or
   * encounters an error it must return the map returned by the predecessor
   * filter's filter() method.
   * If the predecessor's filter() method throws an exception this exception
   * should not be catched (or catched and re-thrown).
   * @return The filtered property map
   * @exception WcmException
   */
  public IPropertyMap filter()
    throws WcmException;

}
