/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.ICollection;
import com.sapportals.wcm.repository.IResourceList;
import com.sapportals.wcm.repository.enum.NamespaceFilterMode;

/**
 * A namespace filter manager implements the behaviour for applying namespace
 * filters. It can decide whether to apply a filter and will create the
 * appropriate filter objects and initialize them with the content to filter.
 *
 * @author SAP AG
 * @version $Revision: #6 $
 */
public interface INamespaceFilterManager extends IFilterManager {

  /**
   * Returns a read filter object that should be applied to the resource list of
   * the predecessor filter. If the manager decides not to apply a filter it
   * must return the reference to the predecessor filter. It should not return
   * null here, but instead throw an exception if something went wrong.
   * Returning null or throwing an exception will stop the filtering process.
   *
   * @param nmspFilter The predecessor filter in the cascade
   * @param mode The namespace filter mode that specifies for which operation
   *      the filter is called (getResource, getChildren, etc.)
   * @return The filter object
   * @exception WcmException
   */
  public INamespaceFilter getFilterForRead(INamespaceFilter nmspFilter, NamespaceFilterMode mode)
    throws WcmException;

  /**
   * Returns a write filter objects
   *
   * @param nmspFilter The predecessor filter in the cascade
   * @return The filter object
   * @exception WcmException Exception raised in failure situation
   */
  public INamespaceFilter getFilterForWrite(INamespaceFilter nmspFilter)
    throws WcmException;
}
