/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.ICollection;
import com.sapportals.wcm.repository.IResourceList;

/**
 * A namespace filter will be applied on namespace operations like
 * getResource(), getChildren(). Example: It can remove or add resource to the
 * list of children of a collection.
 *
 * @author SAP AG
 * @version $Revision:$
 */
public interface INamespaceFilter extends IFilter {

  /**
   * Returns the collection if the filter is applied on getChilden(). Returns
   * null if the filter is applied for getResource() or search().
   *
   * @return The collection value
   * @exception WcmException Description of the Exception
   */
  public ICollection getCollection()
    throws WcmException;


  /**
   * Returns the filtered resource list. A filter implementation must never
   * return <code>null</code> or a new empty list. If the filter will not change the list or
   * encounters an error it must return the list returned by the predecessor
   * filter's filter() method.
   * If the predecessor's filter() method throws an exception this exception
   * should not be catched (or catched and re-thrown).
   *
   * @return The filtered resource list
   * @exception WcmException
   */
  public IResourceList filter()
    throws WcmException;

}
