/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.repository.enum.FilterType;

/**
 * Basic interface for all filter components. When a client requests contents of
 * a resource and a filter is configured for that resource then the content is
 * always returned via the filter. The content itself is fetched from the
 * repository manager, and then passed on to a filter manager for processing.
 *
 * @version $Revision:$
 */
public interface IFilterManager {

  /**
   * Returns the type of the IFilterManager object
   *
   * @return The type of this manager
   */
  public FilterType getType();

}
