/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;

import java.util.Properties;

/**
 * This client interface of the filter factory defines methods for registering
 * and unregistering filters at run-time.
 *
 * @author SAP AG, WCM
 * @version $Revision: #18 $
 */
public interface IFilterFactory {

  /**
   * Register a filter for an additional repository manager. The filter manager
   * must already be registered with its configuration parameters in the CM
   * configuration or a call to <code>register(..., Properties filterConfig)
   * </code>. This method must not be called for URI filters.
   *
   * @param filterID The unique identifier for a filter
   * @param repMgrID A repository manager ID
   * @exception WcmException
   */
  void register(String filterID, String repMgrID)
    throws WcmException;


  /**
   * Register a new filter for a repository manager.
   *
   * @param filterID The unique identifier for a filter
   * @param repMgrID A repository manager ID. This parameter must be <null> if
   *      an URI filter is registered.
   * @param filterConfig The configuration Properties for the filter manager
   * @exception WcmException
   */
  void register(String filterID, String repMgrID, Properties filterConfig)
    throws WcmException;


  /**
   * Unregister a filter
   *
   * @param filterID The filter ID
   * @param repMgrID The repository manager ID. Must be <code>null</code> if a
   *      URI filter will be unregistered.
   * @exception WcmException
   */
  void unregister(String filterID, String repMgrID)
    throws WcmException;

}
