/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.*;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.util.content.*;

/**
 * This interface defines a content filter manager. It is responsible for the
 * creation of content filter instances and the decision if a filter should be
 * applied.
 *
 * @version $Revision:$
 */
public interface IContentFilterManager extends IFilterManager {

  /**
   * Returns a read filter object that should be applied to the content of the
   * predecessor filter. If the manager decides not to apply a filter he must
   * return the reference to the predecessor filter. Implementors should not
   * return null here, but instead throw an exception if something went wrong.
   * Returning null or throwing an exception will stop the filtering process.
   * <p>
   *
   * The implementation of this method must not call the <code>
   * IContentFilter.filter()</Code> method.
   *
   * @param contentFilter The predecessor filter in the cascade
   * @return The filter object
   * @exception WcmException
   */
  IContentFilter getFilterForRead(IContentFilter contentFilter)
    throws WcmException;


  /**
   * Returns a write filter objects.
   *
   * @param contentFilter The predecessor filter in the cascade
   * @return The filter object
   * @exception WcmException
   */
  IContentFilter getFilterForWrite(IContentFilter contentFilter)
    throws WcmException;
}
