/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.util.content.IContent;
import com.sapportals.wcm.util.uri.URI;

/**
 * This interface defines a content filter that will modify the content of a
 * resource. Copyright (c) SAP Portals Europe GmbH 2001
 *
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/filter/IContentFilter.java#7
 *      $
 */
public interface IContentFilter extends IFilter, IContent {

  /**
   * Returns the resource that will be filtered. Will return null if a content
   * write filter is applied before a create operation.
   *
   * @return The resource that will be filtered
   * @exception WcmException
   */
  IResource getResource()
    throws WcmException;


  /**
   * Returns the URI of the new resource in case the write filter is applied
   * before a create operation.
   *
   * @return The URI
   * @exception WcmException
   * @deprecated as of NW04.
   */
  URI getURI()
    throws WcmException;


  /**
   * Returns the repository manager of the new resource in case the write filter
   * is applied before a create operation.
   *
   * @return A reference to a repository manager instance
   * @exception WcmException
   */
  public IRepositoryManager getRepositoryManager()
    throws WcmException;
}
