package com.sapportals.wcm.repository.filter;

import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.repository.ResourceException;

/**
 * The application tried to check out a resource that is not versioned.
 * <p> * Copyright (c) SAP AG 2001-2004
 * @author matthias.rinck@sap.com
 */
public class FilterConfigurationException extends ResourceException {

  String mFilterID = null;

  /**
   * Constructs a new FilterConfigurationException 
   *
   * @param msg The message
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   */
  public FilterConfigurationException (String msg, RID resourceID) {
    super(msg, resourceID, true);
  }

  /**
   * Constructs a new FilterConfigurationException 
   *
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   */
  public FilterConfigurationException (RID resourceID) {
    super(resourceID, true);
  }
  
  /**
    * Constructs a new FilterConfigurationException 
    *
    * @param msg The message
    * @param resourceID The RID of the resource that caused the exception
    *      (optional)
    * @param filterID ID of the filter
    */
  public FilterConfigurationException (String msg, RID resourceID , String filterID) {
      super(msg, resourceID, true);
      mFilterID = filterID;
  }
  
  /**
    * Constructs a new FilterConfigurationException 
    *
    * @param msg The message
    * @param resourceID The RID of the resource that caused the exception
    *      (optional)
    * @param ex Exception
    * @param filterID ID of the filter
    */
  public FilterConfigurationException (String msg, RID resourceID, Exception ex, String filterID) {
  	super(msg, resourceID, ex, true);
  	mFilterID = filterID;
  }
  
  /**
    * Get filter ID of the resource filter.
    * Return null, if not available.
    *
    * @return filter ID
    */
  public String getFilterId() {
    return mFilterID;
  }
  
}


