/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;
import com.sapportals.wcm.crt.configuration.ConfigurationException;
import com.sapportals.wcm.crt.configuration.IConfiguration;
import com.sapportals.wcm.repository.enum.FilterType;

import com.sapportals.wcm.repository.filter.IContentFilterManager;
import java.util.*;

/**
 * Abstract base class for URI filter managers. <p>
 *
 * Copyright (c) SAP AG 2001 - 2002
 *
 * @author Markus Breitenfelder
 * @version $Id:$
 * @deprecated as of EP 5.0 SP5, replaced by {@link AbstractRidFilterManager}.
 */
public abstract class AbstractUriFilterManager extends AbstractFilterManager
   implements IUriFilterManager {

  public AbstractUriFilterManager() {
    super();
  }

  /**
   * @param properties TBD: Description of the incoming method parameter
   * @deprecated as of NW04. Use the default constructor instead
   */
  protected AbstractUriFilterManager(Properties properties) {
    super(properties);
  }

  public final FilterType getType() {
    return FilterType.URI;
  }

  /**
   * @param newConfig TBD: Description of the incoming method parameter
   * @exception ConfigurationException Exception raised in failure situation
   * @see AbstractFilterManager#changeSystemProperties(IConfiguration)
   */
  protected final void changeSystemProperties(IConfiguration newConfig)
    throws ConfigurationException {
    String location = newConfig.getLocation();

    String prefix = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_URIPREFIX, null);

    // Priority
    String priority = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_PRIORITY, null);
    Integer prio;
    if (priority == null || priority.length() < 1) {
      prio = AbstractFilterManager.FILTER_PRIO.MAX;
      // max value = lowest priority
    }
    else {
      prio = new Integer(Integer.parseInt(priority));
    }
    if (prio.compareTo(AbstractFilterManager.FILTER_PRIO.MIN) < 0) {
      this.throwConfigurationException("filter " + this.getID() + ": priority less than min.", location,
        AbstractFilterManager.CFG.FILTERMGR_PRIORITY);
    }
    if (prio.compareTo(AbstractFilterManager.FILTER_PRIO.MAX) > 0) {
      this.throwConfigurationException("filter " + getID() + ": priority greater than max.", location,
        AbstractFilterManager.CFG.FILTERMGR_PRIORITY);
    }

    // List of repository IDs this filter is assigned to
    ArrayList managerIDs = null;
    String managers = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_REPMGRS, null);
    if (managers != null && managers.trim().length() > 0) {
      managerIDs = this.parseValueList(managers, ",");
    }
    else {
      managerIDs = new ArrayList();
    }

    try {
      this.callUpdateFilter(this.getID(), prio, null, null, null, null, null, managerIDs, AbstractFilterManager.TYPE.CONTENT);
    }
    catch (Exception ex) {
      //$JL-EXC$ 
      throw new ConfigurationException("Exception updating filter properties: " + ex.getClass().getName() + ": " + ex.getMessage());
    }
  }
}
