/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;
import com.sapportals.wcm.crt.configuration.ConfigurationException;
/*
 * import com.sapportals.wcm.repository.runtime.CmSystem;
 * import com.sapportals.wcm.repository.runtime.CmRegistry;
 * import com.sapportals.wcm.repository.runtime.CmConfigurationProvider;
 * import com.sapportals.wcm.repository.runtime.CmFilterProperties;
 * import com.sapportals.wcm.repository.runtime.CmStartupException;
 */
import com.sapportals.wcm.crt.configuration.IConfiguration;
import com.sapportals.wcm.repository.enum.FilterType;
import com.sapportals.wcm.repository.IPropertyNameList;
import com.sapportals.wcm.repository.filter.IContentFilterManager;
import com.sapportals.wcm.util.regex.*;
import java.util.*;

/**
 * Abstract base class for property filter managers. <p>
 *
 * Copyright (c) SAP AG 2001 - 2002
 *
 * @author Markus Breitenfelder
 * @version $Id:$
 */
public abstract class AbstractPropertyFilterManager extends AbstractFilterManager
   implements IPropertyFilterManager {

  /**
   * @param properties TBD: Description of the incoming method parameter
   * @deprecated As of EP 5.0 SP5, replaced by default (public, no arguments)
   *      constructor.
   */
  protected AbstractPropertyFilterManager(Properties properties) {
    this.properties = properties;
  }

  public AbstractPropertyFilterManager() {
    super();
  }

  public final FilterType getType() {
    return FilterType.PROPERTY;
  }

  /**
   * Returns the names used by this filter for adding properties.
   * Can be <code>null</code> e.g. in case the filter does not add properties
   * but only removes properties. Property names returned by this call
   * MUST not be persisted as resource properties in a repository. The purpose of
   * this method is a performance optimization done in the RF. The property names
   * returned by this call are never requested from a repository because it is
   * assumed that they are only created by this filter !
   * The RF will call this method only once per filter manager.
   * This base class imlementation returns
   * <code>null</code> and could be overwritten in the sub class.
   * @return the names used by the filter for adding properties.
   */
  public IPropertyNameList getFilteredPropertyNamesForRead() {
    return null;
  }

  /**
   * @param newConfig TBD: Description of the incoming method parameter
   * @exception ConfigurationException Exception raised in failure situation
   * @see AbstractFilterManager#changeSystemProperties(IConfiguration)
   */
  protected final void changeSystemProperties(IConfiguration newConfig)
    throws ConfigurationException {
    String location = newConfig.getLocation();

    // Priority
    String priority = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_PRIORITY, null);
    Integer prio;
    if (priority == null || priority.length() < 1) {
      prio = AbstractFilterManager.FILTER_PRIO.MAX;
      // max value = lowest priority
    }
    else {
      prio = new Integer(Integer.parseInt(priority));
    }
    if (prio.compareTo(AbstractFilterManager.FILTER_PRIO.MIN) < 0) {
      this.throwConfigurationException("filter " + this.getID() + ": priority less than min.", location,
        AbstractFilterManager.CFG.FILTERMGR_PRIORITY);
    }
    if (prio.compareTo(AbstractFilterManager.FILTER_PRIO.MAX) > 0) {
      this.throwConfigurationException("filter " + getID() + ": priority greater than max.", location,
        AbstractFilterManager.CFG.FILTERMGR_PRIORITY);
    }

    // Compile patterns
    PathPatternMatcher extPattern = null;
    PathPatternMatcher pathPattern = null;
    try {
      String pattern = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_PATH, null);
      if (pattern != null && pattern.length() > 0) {
        pathPattern = new PathPatternMatcher(pattern);
      }
    }
    catch (PatternSyntaxException ex) {
      //$JL-EXC$ 
      this.throwConfigurationException("Error in pattern expression: " + ex.getMessage(),
        location, AbstractFilterManager.CFG.FILTERMGR_PATH);
    }
    try {
      String pattern = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_EXTENSIONS, null);
      if (pattern != null && pattern.length() > 0) {
        extPattern = new PathPatternMatcher(pattern);
      }
    }
    catch (PatternSyntaxException ex) {
      //$JL-EXC$ 
      this.throwConfigurationException("Error in pattern expression: " + ex.getMessage(),
        location, AbstractFilterManager.CFG.FILTERMGR_EXTENSIONS);
    }

    String resourceType = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_RESOURCETYPE, null);

    // List of repository IDs this filter is assigned to
    ArrayList managerIDs = null;
    String managers = newConfig.getAttribute(AbstractFilterManager.CFG.FILTERMGR_REPMGRS, null);
    if (managers != null && managers.trim().length() > 0) {
      managerIDs = this.parseValueList(managers, ",");
    }
    else {
      managerIDs = new ArrayList();
    }

    try {
      this.callUpdateFilter(this.getID(), prio, null, null, extPattern, pathPattern, resourceType,
        managerIDs, AbstractFilterManager.TYPE.CONTENT);
    }
    catch (Exception ex) {
      //$JL-EXC$ 
      throw new ConfigurationException("Exception updating filter properties: " + ex.getClass().getName() + ": " + ex.getMessage());
    }
  }
}
