/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.filter;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.WcmObject;
import com.sapportals.wcm.repository.IPropertyMap;
import com.sapportals.wcm.repository.IPropertyNameList;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.enum.PropertyFilterMode;
import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.util.uri.URI;
import java.util.Properties;

/**
 * @todo: Description of the class.
 */
public abstract class AbstractPropertyFilter extends WcmObject implements IPropertyFilter {

  protected IPropertyFilter filter;

  public AbstractPropertyFilter() { }

  /**
   * Construct object of class AbstractPropertyFilter.
   *
   * @param filter TBD: Description of the incoming method parameter
   */
  protected AbstractPropertyFilter(IPropertyFilter filter) {
    if (filter == null) {
      throw new NullPointerException("predecessor filter must not be null");
    }
    this.filter = filter;
  }

  public Properties getFilterContext() {
    return filter.getFilterContext();
  }

  public IResource getResource()
    throws WcmException {
    return filter.getResource();
  }

  public URI getURI()
    throws WcmException {
    return filter.getURI();
  }

  public IRepositoryManager getRepositoryManager()
    throws WcmException {
    return filter.getRepositoryManager();
  }

  public PropertyFilterMode getFilterMode()
    throws WcmException {
    return filter.getFilterMode();
  }

  public IPropertyNameList getPropertyNameList()
    throws WcmException {
    return filter.getPropertyNameList();
  }
}
