/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

/**
 * Definitions for supported options of resources and repositories. <p>
 *
 * Note that some of the options apply to the resource on which the supported
 * option set was requested (they can be used by a user interface to signal
 * which kind of operations make sense on the resource), while others apply to
 * the whole repository (because they signal capabilities of the repository <em>
 * manager</em> ). <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.18 $
 */
import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * TBD: Description of the class.
 */
public final class SupportedOption extends AbstractEnum {

  /**
   * Resource supports access to resource content
   */
  public final static SupportedOption GET_CONTENT = new SupportedOption(1);

  /**
   * Resource supports updating it's content
   */
  public final static SupportedOption UPDATE_CONTENT = new SupportedOption(2);

  /**
   * Resource supports creation of child resources
   */
  public final static SupportedOption CREATE_RESOURCE = new SupportedOption(3);

  /**
   * Resource can be deleted
   */
  public final static SupportedOption DELETE = new SupportedOption(4);

  /**
   * Repository manager does support deleting collections with content
   * (otherwise the framework will do it)
   */
  public final static SupportedOption DELETE_DEEP = new SupportedOption(5);

  /**
   * Resource supports getting resource properties
   */
  public final static SupportedOption GET_PROPERTIES = new SupportedOption(6);

  /**
   * Resource supports setting properties (system properties and custom
   * properties)
   */
  public final static SupportedOption SET_PROPERTIES = new SupportedOption(7);

  /**
   * Repository manager supports renaming resources
   */
  public final static SupportedOption RENAME = new SupportedOption(8);

  /**
   * Repository manager supports creating and modifying internal and external
   * links
   */
  public final static SupportedOption LINKING = new SupportedOption(9);

  /**
   * Resource supports LOCKING operations in general
   */
  public final static SupportedOption LOCKING = new SupportedOption(10);

  /**
   * Resource supports read locks
   */
  public final static SupportedOption LOCKING_READ = new SupportedOption(11);

  /**
   * Resource supports write locks
   */
  public final static SupportedOption LOCKING_WRITE = new SupportedOption(12);

  /**
   * Resource supports shared locks
   */
  public final static SupportedOption LOCKING_SHARED = new SupportedOption(13);

  /**
   * Resource supports exclusive locks
   */
  public final static SupportedOption LOCKING_EXCLUSIVE = new SupportedOption(14);

  /**
   * Resource supports deep locks
   */
  public final static SupportedOption LOCKING_DEEP = new SupportedOption(15);

  /**
   * Resource supports shallow locks
   */
  public final static SupportedOption LOCKING_SHALLOW = new SupportedOption(16);

  /**
   * Repository supports versioning
   */
  public final static SupportedOption VERSIONING = new SupportedOption(17);

  /**
   * Repository supports versioning of collection content
   */
  public final static SupportedOption VERSIONED_COLLECTIONS = new SupportedOption(18);

  /**
   * Repository supports versioning of resource properties
   */
  public final static SupportedOption VERSIONED_PROPERTIES = new SupportedOption(19);

  /**
   * Repository supports versioning of link target URLs
   */
  public final static SupportedOption VERSIONED_LINKS = new SupportedOption(20);

  /**
   * Repository supports the "expected version URI" feature
   */
  public final static SupportedOption EXPECTED_VERSION_URI = new SupportedOption(21);

  /**
   * Resource supports some kind of auto-versioning (see detailed options)
   *
   * @deprecated as of NW04.
   */
  public final static SupportedOption AUTOVERSIONING = new SupportedOption(22);

  /**
   * Repository supports ordered collections
   */
  public final static SupportedOption ORDERED_COLLECTIONS = new SupportedOption(23);

  /**
   * Repository supports the copy operation
   */
  public final static SupportedOption INTERNAL_COPY = new SupportedOption(24);

  /**
   * Repository supports deep copy of collections
   */
  public final static SupportedOption INTERNAL_COPY_DEEP = new SupportedOption(25);

  /**
   * Repository supports copy and move to other repositories. That means it can
   * handle copy/move operations to a target repository which is not the same
   * instance (or type) as the source repository (evtl. a different instance of
   * the same implementation or some kind of "friend" repository ...).
   */
  public final static SupportedOption COPY_MOVE_EXTERNAL = new SupportedOption(44);

  /**
   * Repository supports move method
   */
  public final static SupportedOption INTERNAL_MOVE = new SupportedOption(26);

  /**
   * Repository supports property attributes
   */
  public final static SupportedOption PROPERTY_ATTRIBUTES = new SupportedOption(27);

  /**
   * Repository supports multi-valued properties
   */
  public final static SupportedOption PROPERTY_MULTIVALUED = new SupportedOption(28);

  /**
   * Repository supports creation of collections
   */
  public final static SupportedOption CREATE_COLLECTION = new SupportedOption(29);

  /**
   * Repository resolves links on getResource
   */
  public final static SupportedOption RESOLVES_LINKS = new SupportedOption(30);

  // extensions for new versioning features (julian.reschke@greenbytes.de)

  /**
   * The repository supports version history resources
   */
  public final static SupportedOption VERSION_HISTORY_RESOURCES = new SupportedOption(31);

  /**
   * Resource supports DAV:checkout-checkin autoversion behaviour (see RFC3253:
   * DAV:checkout-checkin)
   *
   * @deprecated as of NW04.
   */
  public final static SupportedOption AUTOVERSIONING_CHECKOUT_CHECKIN = new SupportedOption(32);

  /**
   * Resource supports DAV:checkout-unlocked-checkin autoversion behaviour (see
   * RFC3253: DAV:checkout-unlocked-checkin)
   *
   * @deprecated as of NW04.
   */
  public final static SupportedOption AUTOVERSIONING_CHECKOUT_UNLOCKED_CHECKIN = new SupportedOption(33);

  /**
   * Resource supports DAV:checkout autoversion behaviour (see RFC3253:
   * DAV:checkout)
   *
   * @deprecated as of NW04.
   */
  public final static SupportedOption AUTOVERSIONING_CHECKOUT = new SupportedOption(34);

  /**
   * Resource supports DAV:locked-checkout autoversion behaviour (see RFC3253:
   * DAV:locked-checkout)
   *
   * @deprecated as of NW04.
   */
  public final static SupportedOption AUTOVERSIONING_LOCKED_CHECKOUT = new SupportedOption(35);

  /**
   * Repository supports label methods (see RFC3253: LABEL feature)
   */
  public final static SupportedOption VERSION_LABELS = new SupportedOption(36);

  /**
   * Repository supports working resources (see RFC3253: WORKING RESOURCE
   * feature)
   */
  public final static SupportedOption WORKING_RESOURCE = new SupportedOption(37);

  /**
   * Repository supports the UPDATE method (see RFC3253: UPDATE feature)
   */
  public final static SupportedOption UPDATE_FROM_VERSION = new SupportedOption(38);

  /**
   * Repository supports dynamic internal links. Note that a WebDAV repository
   * manager may report this as available although the remote system doesn't
   * support it. In this case the attempt to create a dynamic link will cause a
   * NotSupportedException.
   */
  public final static SupportedOption INTERNAL_DYNAMIC_LINKS = new SupportedOption(39);

  /**
   * Repository supports workspaces (see RFC3253: WORKSPACE feature)
   */
  public final static SupportedOption WORKSPACES = new SupportedOption(40);

  /**
   * Resource can be taken under or out of version control
   */
  public final static SupportedOption VERSION_CONTROL = new SupportedOption(41);

  /**
   * Collection supports workspace creation
   */
  public final static SupportedOption CREATE_WORKSPACE = new SupportedOption(42);

  /**
   * Resource lies in non-hierarchical namespace. Parent collections might not
   * exist.
   */
  public final static SupportedOption NONHIERARCHICAL_NAMESPACE = new SupportedOption(43);

  private SupportedOption(int code) {
    super(code);
  }
}
