/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * Property tpyes
 */
public final class PropertyType extends AbstractEnum {

  public final static PropertyType STRING = new PropertyType(1);
  public final static PropertyType INTEGER = new PropertyType(2);
  public final static PropertyType LONG = new PropertyType(3);
  public final static PropertyType DATE = new PropertyType(4);
  public final static PropertyType BOOLEAN = new PropertyType(5);
  public final static PropertyType XML = new PropertyType(6);

  private PropertyType(int code) {
    super(code);
  }

  public int hashCode() {
    return super.m_code;
  }

  public boolean equals(Object other) {
    if (other instanceof PropertyType) {
      return super.m_code == ((PropertyType)other).m_code;
    }
    return false;
  }
}
