/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * The property filter mode specifies for which operation the filter is applied.
 *
 * @author Jens Kaiser
 * @version $Revision:$
 */
public final class PropertyFilterMode extends AbstractEnum {

  /**
   * Description of the Field
   */
  public final static PropertyFilterMode SINGLE_PROPERTY = new PropertyFilterMode(1);
  /**
   * Description of the Field
   */
  public final static PropertyFilterMode PROPERTY_LIST = new PropertyFilterMode(2);
  /**
   * Description of the Field
   */
  public final static PropertyFilterMode ALL_PROPERTIES = new PropertyFilterMode(3);


  private PropertyFilterMode(int code) {
    super(code);
  }
}
