/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * Positioning information for ordered collections
 *
 * @version $Revision:$
 */
public final class OrderPosition extends AbstractEnum {

  /**
   * First position
   */
  public final static OrderPosition FIRST = new OrderPosition(1);
  /**
   * Last position
   */
  public final static OrderPosition LAST = new OrderPosition(2);
  /**
   * Before
   */
  public final static OrderPosition BEFORE = new OrderPosition(3);
  /**
   * After
   */
  public final static OrderPosition AFTER = new OrderPosition(4);


  private OrderPosition(int code) {
    super(code);
  }
}
