/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * Operator for IQueryEntry
 */
public final class Operator extends AbstractEnum {

  public final static Operator EQUAL = new Operator(1);
  public final static Operator GREATER = new Operator(2);
  public final static Operator LESS = new Operator(3);
  public final static Operator LESS_OR_EQUAL = new Operator(4);
  public final static Operator GREATER_OR_EQUAL = new Operator(5);
  public final static Operator LIKE = new Operator(6);
  public final static Operator REGEXP = new Operator(7);

  private Operator(int code) {
    super(code);
  }
}
