/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * The namespace filter mode specifies for which operation the filter is
 * applied.
 */
public final class NamespaceFilterMode extends AbstractEnum {

  public final static NamespaceFilterMode GET_CHILDREN = new NamespaceFilterMode(1);
  public final static NamespaceFilterMode GET_RESOURCE = new NamespaceFilterMode(2);
  public final static NamespaceFilterMode GET_VERSIONHISTORY = new NamespaceFilterMode(3);
  public final static NamespaceFilterMode SEARCH = new NamespaceFilterMode(4);

  private NamespaceFilterMode(int code) {
    super(code);
  }
}
