package com.sapportals.wcm.repository.enum;


import com.sapportals.wcm.util.enum.AbstractEnum;


/**
 * Link type
 *
 * @version    $Revision:$
 */
public final class LinkType extends AbstractEnum {

  /**  No-typed link */
  public final static LinkType NONE = new LinkType( 1 );
  /**
   * An internal link refers to a resource that is located in one of the
   * defined KM repositories.
   */
  public final static LinkType INTERNAL = new LinkType( 2 );
  /**
   * An external link refers to a  resource that is not located in a
   * KM repository.
   */
  public final static LinkType EXTERNAL = new LinkType( 3 );


  private LinkType( int code ) {
    super( code );
  }

  public static String linkType2String(LinkType lt) {
    if (lt.NONE.equals(lt)) return "none";
    if (lt.EXTERNAL.equals(lt)) return "external";
    if (lt.INTERNAL.equals(lt)) return "internal";
    return "undefined";
  }

  public static LinkType linkTypeFromString(String lts) {
    if (lts.equals("none"))       return LinkType.NONE;
    if (lts.equals("external"))   return LinkType.EXTERNAL;
    if (lts.equals("internal"))   return LinkType.INTERNAL;
    return null;
  }
}
