/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.enum;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * Repository filter types.
 *
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/enum/FilterType.java#8
 *      $
 * @see com.sapportals.wcm.repository.filter.IFilterManager
 * @see com.sapportals.wcm.repository.filter.IFilter
 */
public final class FilterType extends AbstractEnum {

  /**
   * Content filter process the content of resources
   */
  public final static FilterType CONTENT = new FilterType(1);
  /**
   * Property filter modify and control the visibility of resource properties
   */
  public final static FilterType PROPERTY = new FilterType(2);
  /**
   * Namespace filter control the visibility of resources
   */
  public final static FilterType NAMESPACE = new FilterType(3);
  /**
   * URI filter process the resource uri
   */
  public final static FilterType URI = new FilterType(4);


  private FilterType(int code) {
    super(code);
  }
}
