/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.batch;

import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.util.uri.RID;
import java.util.*;

/**
 * Helper class that can be used to handle the return value of {@link IResourceBatch#getProperties(IPropertyNameList, ResourceErrors)}.
 */
public final class ResourcePropertyMap {
  private Map map;

  /**
   * Constructs a new instance.
   * @param map A map returned by {@link IResourceBatch#getProperties(IPropertyNameList, ResourceErrors)}.
   */
  public ResourcePropertyMap(Map map) {
    this.map = map;
  }

  /**
   * Returns the property map for the specified RID. If none of the requested properties exist
   * a empty map is returned.
   * @param rid The RID to get the properties for.
   * @return the property map for the specified RID.
   */
  public IPropertyMap getProperties(RID rid) {
    if (this.map == null) {
      return new PropertyMap();
    }
    IPropertyMap m = (IPropertyMap)this.map.get(rid);
    if (m == null) {
      return new PropertyMap();
    }
    return m;
  }

  /**
   * Returns a list of names of properties that are not contained in the map for the specified RID.
   * The returned list will be a subset of the names to check for.
   * @param rid The RID to check the properties for.
   * @param checkNames The list of property names to check against the available properties.
   * @return a list of names of properties that are not contained in the map for the specified RID.
   */
  public IPropertyNameList calculateNotContainedNames(RID rid, IPropertyNameList checkNames) {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns a list of names of properties that are contained in the map for the specified RID.
   * The returned list will be a subset of the names to check for.
   * @param rid The RID to check the properties for.
   * @param checkNames The list of property names to check against the available properties.
   * @return a list of names of properties that are contained in the map for the specified RID.
   */
  public IPropertyNameList calculateContainedNames(RID rid, IPropertyNameList checkNames) {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns a collection of exceptions that occurred for a specified RID.
   * @param rid The rid to get the excpetion for.
   * @return Returns a collection of exceptions that occurred for a specified RID.
   */
  public ResourceErrors getExceptions(RID rid) {
    throw new UnsupportedOperationException();
  }
}