/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.batch;

import com.sapportals.wcm.crt.CrtClassLoaderRegistry;
import com.sapportals.wcm.repository.*;
import com.sap.tc.logging.Location;
import com.sapportals.wcm.util.logging.LoggingFormatter;

import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * Can be used to call batch operations for a list of resources of one or more repositories.
 * <p>
 * Note: This interface is for internal use only and is currently not released and documented.
 */
public interface IResourceBatch {

  /**
   * Returns a map containing the requested properties which are available for the resources in this resource batch.
   * The resulting map will contain resource identifiers ({@link com.sapportals.wcm.util.uri.RID}) as keys and
   * {@link com.sapportals.wcm.repository.IPropertyMap} instances as values.
   * If a resource does not exist no entry will exist in the map for the RID (a resource might no longer exist
   * because it was deleted by another user/thread since ICollection.getChildren() or IResourceFactory.getResources() was called).
   * If a ResourceException occurred for some resources the exceptions will be contained in the (optional) ResourceErrors object.
   * If the ResourceErrors collection contains an exception for a particular RID then this RID will not
   * be contained in the map.
   * If none of the properties exist for a resource the RID is not contained in the map.
   * If none of the properties exist for all of the specified resources (or the resource list is empty)
   * the return value is <code>null</code>.
   * If a property for a specified name does not exist it will not be contained in the IPropertyMap.
   * If a ResourceException is caused by one of the properties it will be appended to
   * the IPropertyMap instance and can be accessed with {@link IPropertyMap#getException(IPropertyName)} or
   * {@link IPropertyMap#getExceptions()}.
   * @param propNameList A list of property names. Must not be <code>null</code>.
   * @param errors Will be used to collect all exceptions which occurred when trying to access the properties
   * of a resource. Can be <code>null</code>.
   * @return a map containing the requested properties which are available for the resources in this resource batch.
   * Can be <code>null</code>.
   * @exception ResourceException
   */
  /*public Map getProperties(IPropertyNameList propNameList, ResourceErrors errors) throws ResourceException;*/
}