/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 * 
 * @author d021856
 *
 * @version $Id: //kmgmt/bc.util/dev/src/_public/java/api/com/sapportals/wcm/util/content/VirusContentException.java#8 $
 *
 * Some error in the VSI / VSA occured
 */
 
package com.sapportals.wcm.repository; //com.sapportals.wcm.util.content;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.MissingResourceException;
import java.text.MessageFormat;

/**
 * This exception is raised when a check reveals that content being read/written possibly contains a Virus.
 * <p>
 * Copyright (c) SAP AG 2004
 * @author stefan.fuchs@sap.com
 */

public class VirusContentException extends ResourceException
{
  private int rc;
  private String desc;
  private String inf;
	/**
	 * 
	 */
	private VirusContentException()
	{
		super();
		desc = getBundleText("noerror","No error");
		rc = 0;
	}

	/**
	 * @param rc return code
	 * @param errordesc Description of returncode
	 * @param s Description of error (e.g. type of virus)
	 */
	public VirusContentException(int rc, String errordesc, String s)
	{
    super((s != null && !s.trim().equals("")) ?
      getBundleText("virus","Operation failed. Virus found - please contact your system administrator")
    : ((errordesc != null && !errordesc.trim().equals("")) || rc != 0) ?
      getBundleText("scan","Operation failed. Error scanning document - please contact your system administrator")
    :
      getBundleText("noerror","No error")); 
		this.desc = errordesc;
    this.inf = s;
		this.rc = rc;
	}
	
  /**
   * @return Return codes as defined in the J2EE VSIService
   */
  public int getReturncode() {
  	return rc;
  }
  
  /**
   * @return The textual description of the return code 
   *         (should be visible only to admins)
   */
  public String getErrorDesc() {
  	if (desc != null && !desc.trim().equals(""))
  	  return desc;
  	return "no error description available";
  }
  
  /**
   * @return The textual description of the virus type 
   *         (should be visible only to admins)
   */
  public String getInfection() {
    if (inf != null && ! inf.trim().equals("")) 
      return inf;
    return "no virus information available";
  }
  
  /**
   * @return This message can be shown to anybody. 
   *         It only says "virus found" or "scan error" 
   */ 
	public String getMessage() {
		return super.getMessage();
	}
  
  /**
   * @return The locale of the @see com.sapportals.wcm.util.content.VirusContentException#getMessage call 
   */ 
  public Locale getLocale() {
    return Locale.getDefault();
  }
  
  private static String getBundleText(String key, String defaultText) {
    String result = null;
    try {
      result=ResourceBundle.getBundle(VirusContentException.class.getName()).getString(key);
    }
    catch(MissingResourceException e) {
      //$JL-EXC$ 
      result = defaultText;
    }
    return result != null ? result : defaultText;
  }


}
