/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * ResourceException thrown if someone tries to create a Vcr in a workspace that
 * already contains a vcr with the same version history.
 */
public class VersionHistoryInUseException extends ResourceException {

  private RID conflict;

  /**
   * Constructs a VersionHistoryInUseException to indicate that the current
   * operation would result in a workspace containing two vcrs based on the same
   * version history.
   *
   * @param version The RID of the version resource that was intended to act as
   *      the base of the new workspace controlled vcr.
   * @param msg TBD: Description of the incoming method parameter
   * @param conflictVcr TBD: Description of the incoming method parameter
   */
  public VersionHistoryInUseException(String msg, RID version, RID conflictVcr) {
    super(msg, version, false);
    this.conflict = conflictVcr;
  }

  /**
   * @return the RID of the workspace controlled vcr that causes the conflict
   *      (may be null if not supplied by server).
   */
  public RID getConflictingRID() {
    return this.conflict;
  }
}
