/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * The checkout operation failed because the version to be checked out has
 * descendants in it's version history and the resulting version history fork is
 * not allowed in current context. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author manfred.baedke@greenbytes.de
 */
public class VersionHasDescendantsException extends ResourceException {

  /**
   * Constructs a new exception
   *
   * @param resourceID The ID of the resource this exception belongs to
   * @param msg TBD: Description of the incoming method parameter
   */
  public VersionHasDescendantsException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }
}
