/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * Raised when the name can not be assigned because (1) a "similar" name already
 * exists (for instance, if "a" already exists in a case-preserving but not
 * case-sensitive repository, and creation of "A" was attempted) or (2) the name
 * is syntactically legal, but can not be reassigned to a new resource (stable
 * names for versions and version histories). <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: UnassignableNameException.java,v 1.1 2002/11/05 11:15:05 jre
 *      Exp $
 */
public class UnassignableNameException extends ResourceException {

  public UnassignableNameException(String msg) {
    super(msg, false);
  }


  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   */
  public UnassignableNameException(com.sap.netweaver.bc.rf.common.namespace.ResourceNameUnassignableException newEx) {
    super(newEx);
  }

}
