/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.*;
import java.util.*;

/**
 * Implements the {@link ITypedResourceList} interface.
 * <p>
 *  Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @version $Revision: 1.5 $
 * @see ITypedResourceList
 */
public class TypedResourceList extends ResourceList implements ITypedResourceList {

  private String listType;
  private Map props;

  /**
   * Construct a new resource list containing the elements of the specified list
   * in the same order.
   */
  public TypedResourceList(ResourceList resourceList) {
    super(resourceList);
  }

  /**
   * Constructs a new empty resource list with a type.
   *
   * @param listType the type attribute of this list.
   */
  public TypedResourceList(String listType) {
    super();
    this.listType = listType;
  }

  public boolean remove(IResource resource) {
    boolean b = super.remove(resource);
    if (this.props != null) {
      this.props.remove(resource);
    }
    return b;
  }

  public IResource remove(int index) {
    IResource r = super.remove(index);
    if (this.props != null && r != null) {
      this.props.remove(r);
    }
    return r;
  }


  // -----------------------------
  // ITypedResourceList interface
  // -----------------------------

  public String getType() {
    return this.listType;
  }

  public void setType(String listType) {
    this.listType = listType;
  }

  public Map getPropertyBag(IResource res) {
    if (res == null) {
      return null;
    }
    Object retMap = this.props.get(res);
    if (null != retMap) {
      return (Map)retMap;
    }
    else {
      return null;
    }
  }

  public void setPropertyBag(IResource res, Map propertyBag)
    throws WcmException {
    if (res == null) {
      throw new NullPointerException("resource is null");
    }
    if (propertyBag == null) {
      throw new NullPointerException("propertyBag is null");
    }
    if (this.props == null) {
      this.props = new HashMap();
    }
    else {
      if (!this.containsResource(res)) {
        throw new WcmException("The resource is not contained in the list: " + res.getRID());
      }
    }
    this.props.put(res, propertyBag);
  }
}
