/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.*;
import java.util.*;

/**
 * A set of supported operations for a resource
 */
public class SupportedOptionSet implements ISupportedOptionSet {

  private HashSet options;

  public SupportedOptionSet() {
    this.options = new HashSet();
  }

  public SupportedOptionSet(Set set) {
    this.options = new HashSet(set);
  }

  public boolean isSupported(SupportedOption op) {
    return this.options.contains(op);
  }

  public void add(SupportedOption op) {
    this.options.add(op);
  }

  public Iterator iterator() {
    return this.options.iterator();
  }
}
