/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.List;

import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * This exception indicates errors during a {@link IResource#setProperties(List))}
 * call. If some or all properties could not be set for some reason, {@link #getPropertyChangeResults()}
 * returns the property names and the exceptions.
 * <p>
 * Copyright SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 */
public class SetPropertiesException extends ResourceException {

  PropertyChangeResultCollection propChangeResults = null;

  /**
   * @deprecated as of NW04.
   */
  public SetPropertiesException(String msg, URI resourceID, PropertyChangeResultCollection propChangeResults) {
    super(msg, resourceID, false);
    this.propChangeResults = propChangeResults;
  }

  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param resourceID The ID of the resource this exception belongs to
   */
  public SetPropertiesException(String msg, RID resourceID, PropertyChangeResultCollection propChangeResults) {
    super(msg, resourceID, false);
    this.propChangeResults = propChangeResults;
  }

  /**
   * Constructs a new exception.
   */
  public SetPropertiesException(PropertyChangeResultCollection propChangeResults) {
    super(false);
    this.propChangeResults = propChangeResults;
  }

  /**
   * Returns the contained property change results
   *
   * @return the contained property change results
   */
  public PropertyChangeResultCollection getPropertyChangeResults() {
    return this.propChangeResults;
  }
}
