/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

import java.util.Date;

/**
 * A service is not available. <p>
 *
 * Copyright 2002 (c) SAP AG
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: ServiceUnavailableException.java,v 1.2 2002/12/04 16:14:35 jre
 *      Exp $
 */
public class ServiceUnavailableException extends ResourceException {

  private final Date retry;


  /**
   * Constructs a new ServiceUnavailableException
   *
   * @param msg The message
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public ServiceUnavailableException(String msg, RID resourceID) {
    super(msg, resourceID, false);
    this.retry = null;
  }


  /**
   * Constructs a new ServiceUnavailableException
   *
   * @param msg The message
   * @param retry date before which retries are not recommended
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public ServiceUnavailableException(String msg, Date retry, RID resourceID) {
    super(msg, resourceID, false);
    this.retry = retry;
  }


  /**
   * Constructs a new ServiceUnavailableException
   *
   * @param msg The message
   * @param ex The contained exception
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public ServiceUnavailableException(String msg, Exception ex, RID resourceID) {
    super(msg, resourceID, ex, false);
    this.retry = null;
  }


  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   * @param retry date before which retries are not recommended
   */
  public ServiceUnavailableException(com.sap.netweaver.bc.rf.common.exception.ServiceNotAvailableException newEx, Date retry) {
    super(newEx);
    this.retry = retry;
  }


  /**
   * Returns the time when retries of the operation are recommended. Repeating
   * the operation before this time, will most likely raise this exception
   * again. If the best time for retry is unknown, <code>null</code> is retuned.
   *
   * @return time of first recommended retry or <code>null</code> if not known.
   */
  public Date getRetryAfter() {
    return this.retry;
  }
}
