/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: ResourceNotFoundException.java,v 1.3 2004/05/27 11:33:52 jre Exp $
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * Indicates that a resource could not be found. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Revision: 1.3 $
 */
public class ResourceNotFoundException extends ResourceException {

  /**
   * Constructs a new exception
   *
   * @param msg The message
   */
  public ResourceNotFoundException(String msg) {
    super(msg, false);
  }

  /**
   * @deprecated as of NW04.
   */
  public ResourceNotFoundException(URI resourceID) {
    super(resourceID, false);
  }

  /**
   * @deprecated as of NW04.
   */
  public ResourceNotFoundException(String msg, URI resourceID) {
    super(msg, resourceID, false);
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   */
  public ResourceNotFoundException(RID resourceID) {
    super(resourceID, false);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   */
  public ResourceNotFoundException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }
}
