/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.repository.ResourceException;

import com.sapportals.wcm.util.uri.RID;

/**
 * Indicates that the resource has changed to a non-collection since the
 * IResource object was obtained. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.3 $
 */
public class ResourceNotCollectionException extends ResourceException {

  /**
   * Constructs a new ResourceNotCollection
   *
   * @param resourceID The RID of the resource that caused the exception
   */
  public ResourceNotCollectionException(RID resourceID) {
    super(resourceID, false);
  }

}
