/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.ListIterator;
import java.util.HashSet;

/**
 * Iterator for the resource list
 *
 * @author SAP AG
 * @version $Revision:$
 */
public class ResourceListIterator implements IResourceListIterator {

  private IResource m_last;
  private final HashSet m_set;
  private final ListIterator m_iterator;

  public ResourceListIterator(HashSet set,
                              ListIterator iterator) {
    m_last = null;
    m_set = set;
    m_iterator = iterator;
  }

  public boolean hasNext() {
    return m_iterator.hasNext();
  }

  public IResource next() {
    m_last = (IResource)m_iterator.next();
    return m_last;
  }

  public boolean hasPrevious() {
    return m_iterator.hasPrevious();
  }

  public IResource previous() {
    m_last = (IResource)m_iterator.previous();
    return m_last;
  }

  public int nextIndex() {
    return m_iterator.nextIndex();
  }

  public int previousIndex() {
    return m_iterator.previousIndex();
  }

  public void remove() {
    if( m_last != null ) m_set.remove(m_last);
    m_iterator.remove();
  }

  public void set(IResource resource) {
    if( m_last != null ) { m_set.remove(m_last); m_set.add(resource); } 
    m_iterator.set(resource);
  }

  public void add(IResource resource) {
    m_set.add(resource);
    m_iterator.add(resource);
  }
  
}

