/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.LinkType;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * This exception is thrown during copy or move operations if the <code>
 * CopyParameter</code> has copyInternalLink or copyExternalLink set to <code>
 * true</code> and links are encountered during a deep copy operation.
 * <p>
 * Copyright (c) SAP AG 2001-2004
 */
public class ResourceIsLinkException extends ResourceException {

  private LinkType m_linkType = LinkType.NONE;
  private String m_targetURL = null;

  /**
   * @param resourceID TBD: Description of the incoming method parameter
   * @param linkType TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public ResourceIsLinkException(URI resourceID, LinkType linkType) {
    super(resourceID, false);
    m_linkType = linkType;
  }

  /**
   * @param resourceID TBD: Description of the incoming method parameter
   * @param linkType TBD: Description of the incoming method parameter
   * @param targetURL TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public ResourceIsLinkException(URI resourceID, LinkType linkType, String targetURL) {
    super(resourceID, false);
    m_linkType = linkType;
    m_targetURL = targetURL;
  }

  /**
   * Constructs a new ResourceIsLinkException
   *
   * @param resourceID The RID of the resource that caused the exception
   * @param linkType The type of link that caused the exception
   */
  public ResourceIsLinkException(RID resourceID, LinkType linkType) {
    super(resourceID, false);
    m_linkType = linkType;
  }

  /**
   * Constructs a new ResourceIsLinkException
   *
   * @param resourceID The RID of the resource that caused the exception
   * @param linkType The type of link that caused the exception
   * @param targetURL The target URL of the link the caused the exception
   */
  public ResourceIsLinkException(RID resourceID, LinkType linkType, String targetURL) {
    super(resourceID, false);
    m_linkType = linkType;
    m_targetURL = targetURL;
  }

  /**
   * Returns the type of the link that caused the exception
   *
   * @return the type of the link that caused the exception
   */
  public LinkType getLinkType() {
    return m_linkType;
  }

  /**
   * Returns the target URL of the link that caused the exception
   *
   * @return the target URL of the link that caused the exception
   */
  public String getTargetURL() {
    return m_targetURL;
  }
}
