/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import java.lang.reflect.InvocationTargetException;

import com.sap.tc.logging.Location;
import com.sapportals.wcm.crt.CrtClassLoaderRegistry;
import com.sapportals.wcm.util.logging.LoggingFormatter;

/**
 * The ResourceFactory is used to create instances of resource objects. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 */
public class ResourceFactory {

  private static Location log = Location.getLocation(com.sapportals.wcm.repository.ResourceFactory.class);

  private static IResourceFactory adapter;

  private ResourceFactory() { }

  /**
   * Returns a reference to the resource factory instance.
   *
   * @return a reference to the resource factory instance.
   * @exception ResourceException
   */
  public static synchronized IResourceFactory getInstance()
    throws ResourceException {
    if (adapter == null) {
      try {
        Class adapterClass = null;
        adapterClass = CrtClassLoaderRegistry.forName("com.sapportals.wcm.repository.runtime.CmAdapter");
        ResourceFactory.adapter = (IResourceFactory)adapterClass.getMethod("getInstance", null).invoke(null, null);
      }
      catch (InvocationTargetException e) {
        //$JL-EXC$ 
        ResourceFactory.log.errorT("getInstance(63)", LoggingFormatter.extractCallstack(e.getTargetException()));
        throw new ResourceException("InvocationTargetException: " + e.getTargetException().getMessage());
      }
      catch (Exception e) {
        throw new ResourceException(e);
      }
    }
    return adapter;
  }
}

