/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: ResourceException.java,v 1.3 2004/05/27 11:33:52 jre Exp $
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.content.ContentException;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * Resource Exception. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @version $Revision: 1.3 $
 */
public class ResourceException extends ContentException {
  com.sap.netweaver.bc.rf.common.exception.ResourceException modernResourceException = null;

  /**
   * The ID (RID) of the resource this exception belongs to
   */
  private RID rid = null;

  /**
   * Reference to the next ResourceException
   */
  private ResourceException nextEx = null;


  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newResourceException The new exception.
   */
  public ResourceException(com.sap.netweaver.bc.rf.common.exception.ResourceException newResourceException) {
    super(true);
    this.modernResourceException = newResourceException;
  }


  /**
   * Constructs a new exception
   */
  public ResourceException() {
    super(true);
  }


  /**
   * Constructs a new exception
   *
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(boolean log) {
    super(log);
  }


  /**
   * @param resourceID
   * @deprecated as of NW04.
   */
  public ResourceException(URI resourceID) {
    super(true);
    this.rid = RID.getRID(resourceID.toString());
  }


  /**
   * Constructs a new exception
   *
   * @param resourceID The ID of the resource this exception belongs to
   */
  public ResourceException(RID resourceID) {
    super(true);
    this.rid = resourceID;
  }


  /**
   * @param resourceID
   * @param log
   * @deprecated as of NW04.
   */
  public ResourceException(URI resourceID, boolean log) {
    super(log);
    this.rid = RID.getRID(resourceID.toString());
  }


  /**
   * Constructs a new exception
   *
   * @param resourceID The ID of the resource this exception belongs to
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(RID resourceID, boolean log) {
    super(log);
    this.rid = resourceID;
  }


  /**
   * @param msg
   * @param resourceID
   * @deprecated as of NW04.
   */
  public ResourceException(String msg, URI resourceID) {
    super(msg, true);
    this.rid = RID.getRID(resourceID.toString());
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param resourceID The ID of the resource this exception belongs to
   */
  public ResourceException(String msg, RID resourceID) {
    super(msg, true);
    this.rid = resourceID;
  }


  /**
   * @param msg
   * @param resourceID
   * @param log
   * @deprecated as of NW04.
   */
  public ResourceException(String msg, URI resourceID, boolean log) {
    super(msg, log);
    this.rid = RID.getRID(resourceID.toString());
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param resourceID The ID of the resource this exception belongs to
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(String msg, RID resourceID, boolean log) {
    super(msg, log);
    this.rid = resourceID;
  }


  /**
   * @param msg
   * @param resourceID
   * @param ex
   * @deprecated as of NW04.
   */
  public ResourceException(String msg, URI resourceID, Exception ex) {
    super(msg, ex);
    this.rid = RID.getRID(resourceID.toString());
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param resourceID The ID of the resource this exception belongs to
   * @param ex The contained exception
   */
  public ResourceException(String msg, RID resourceID, Exception ex) {
    super(msg, ex);
    this.rid = resourceID;
  }


  /**
   * @param msg
   * @param resourceID
   * @param ex
   * @param log
   * @deprecated as of NW04.
   */
  public ResourceException(String msg, URI resourceID, Exception ex, boolean log) {
    super(msg, ex, log);
    this.rid = RID.getRID(resourceID.toString());
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param resourceID The ID of the resource this exception belongs to
   * @param ex The contained exception
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(String msg, RID resourceID, Exception ex, boolean log) {
    super(msg, ex, log);
    this.rid = resourceID;
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   */
  public ResourceException(String msg) {
    super(msg);
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(String msg, boolean log) {
    super(msg, log);
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param ex The contained exception
   */
  public ResourceException(String msg, Exception ex) {
    super(msg, ex);
  }


  /**
   * Constructs a new exception
   *
   * @param msg The messsage text
   * @param ex The contained exception
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(String msg, Exception ex, boolean log) {
    super(msg, ex, log);
  }


  /**
   * Constructs a new exception
   *
   * @param ex The contained exception
   */
  public ResourceException(Exception ex) {
    super(ex);
  }


  /**
   * Constructs a new exception
   *
   * @param ex The contained exception
   * @param log If <code>true</code> the stack trace will be written to the
   *      error log.
   */
  public ResourceException(Exception ex, boolean log) {
    super(ex, log);
  }


  /**
   * Sets a reference to the next ResourceException
   *
   * @param nextEx
   */
  public void setNextResourceException(ResourceException nextEx) {
    this.nextEx = nextEx;
  }


  /**
   * @return
   * @deprecated as of NW04.
   */
  public URI getResourceID() {
    if (modernResourceException != null) {
      return modernResourceException.getRID() == null ? null : new URI(modernResourceException.getRID().toString());
    }
    return this.rid == null ? null : new URI(rid.toString());
  }


  /**
   * Returns the URI of the resource that caused the exception or <code>null
   * </code>.
   *
   * @return
   */
  public RID getRID() {
    if (modernResourceException != null) {
      return modernResourceException.getRID() == null ? null : RID.getRID(modernResourceException.getRID().toString());
    }
    return this.rid;
  }


  /**
   * Returns the next ResourceException or <code>null</code>
   *
   * @return
   */
  public ResourceException getNextResourceException() {
    return this.nextEx;
  }


  public String getMessage() {
    if (modernResourceException != null) {
      return modernResourceException.getMessage();
    }
    else {
      return super.getMessage();
    }
  }


  public String getLocalizedMessage() {
    if (modernResourceException != null) {
      return modernResourceException.getLocalizedMessage();
    }
    else {
      return super.getLocalizedMessage();
    }
  }


  public String toString() {
    if (modernResourceException != null) {
      return modernResourceException.toString();
    }
    else {
      return super.toString();
    }
  }


  public void printStackTrace() {
    if (modernResourceException != null) {
      modernResourceException.printStackTrace();
    }
    else {
      super.printStackTrace();
    }
  }


  public void printStackTrace(java.io.PrintStream s) {
    if (modernResourceException != null) {
      modernResourceException.printStackTrace(s);
    }
    else {
      super.printStackTrace(s);
    }
  }


  public void printStackTrace(java.io.PrintWriter s) {
    if (modernResourceException != null) {
      modernResourceException.printStackTrace(s);
    }
    else {
      super.printStackTrace(s);
    }
  }


  public Throwable fillInStackTrace() {
    if (modernResourceException != null) {
      return modernResourceException.fillInStackTrace();
    }
    else {
      return super.fillInStackTrace();
    }
  }
}
