/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * This is a collection of resource exceptions. This class is used for methods that
 * operate on multiple resources. This is an example how it can be used:
 * <p>
 * <code>
 * ResourceErrors errors = new ResourceErrors();
 * IRsourceList list = ResourceFactory.getInstance().getResources(ridList, errors, context);
 * ResourceException ex = errors.getResourceException();
 * while (ex != null) {
 *   System.out.println(ex.getResourceID() + ": " + ex.getMessage());
 *   ex = ex.getNextResourceException();
 * }
 * </code>
 */
public class ResourceErrors {

  private ResourceException first = null;
  private ResourceException next = null;

  /**
   * Constructs a new instance
   */
  public ResourceErrors() { }

  /**
   * Appends the exception to the list
   *
   * @param ex The exception to append
   */
  public void append(ResourceException ex) {
    // Navigate to the last exception
    ResourceException last = ex;
    while (last.getNextResourceException() != null) {
      last = last.getNextResourceException();
    }

    if (this.first == null) {
      this.next = last;
      this.first = ex;
    }
    else {
      this.next.setNextResourceException(ex);
      this.next = last;
    }
  }

  /**
   * Appends the list of exceptions to this list
   *
   * @param errors The list to append
   */
  public void append(ResourceErrors errors) {
    ResourceException ex = errors.getResourceException();
    if (ex != null) {
      this.append(ex);
    }
  }

  /**
   * Returns a reference to the first exception.
   *
   * @return The first resource exception in the list
   */
  public ResourceException getResourceException() {
    return this.first;
  }
}
