/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.*;

/**
 * An iterator for <code>IReorderList</code> instances. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public class ReorderListIterator implements IReorderListIterator {

  private ListIterator m_it = null;

  public ReorderListIterator(ListIterator it) {
    m_it = it;
  }

  public boolean hasNext() {
    return m_it.hasNext();
  }

  public IPositioning next() {
    return (IPositioning)m_it.next();
  }
}
