/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Raised when a property value was too big. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author julian.reschke@greenbytes.de
 */
public class PropertyValueTooBigException extends AbstractPropertyException {

  private int max;

  public PropertyValueTooBigException(String message, RID rid, IPropertyName name, int max) {
    super(message, rid, name);
    this.max = max;
	}

  /**
   * @return maximum length for property value (or <code>0</code> when unknown)
   */
  public int getMax() {
    return this.max;
  }
}
