/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Raised when an attempt was made to set a protected property with a
 * non-applicable data type. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author martin.boettcher@greenbytes.de
 * @version $Id: PropertyTypeMismatchException.java,v 1.2 2002/08/30 11:35:43
 *      jre Exp $
 */
public class PropertyTypeMismatchException extends AbstractPropertyException {

  /**
   * Constructs a new exception
   *
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   * @param propertyName The name of the property that caused the exception
   *      (optional)
   */
  public PropertyTypeMismatchException(RID resourceID, IPropertyName propertyName) {
    super(null, resourceID, propertyName);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   * @param propertyName The name of the property that caused the exception
   *      (optional)
   */
  public PropertyTypeMismatchException(String msg, RID resourceID, IPropertyName propertyName) {
    super(msg, resourceID, propertyName);
  }
}
