/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * The property cannot be changed because it is read-only.
 * <p>
 * Copyright SAP AG 2001-2004
 */
public class PropertyReadOnlyException extends AbstractPropertyException {

  /**
   * @deprecated as of NW04.
   */
  public PropertyReadOnlyException(URI resourceID, IPropertyName propertyName) {
    super(null, resourceID, propertyName);
  }

  /**
   * @deprecated as of NW04.
   */
  public PropertyReadOnlyException(String msg, URI resourceID, IPropertyName propertyName) {
    super(msg, resourceID, propertyName);
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   * @param propertyName The name of the property that caused the exception
   *      (optional)
   */
  public PropertyReadOnlyException(RID resourceID, IPropertyName propertyName) {
    super(null, resourceID, propertyName);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message Text
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   * @param propertyName The name of the property that caused the exception
   *      (optional)
   */
  public PropertyReadOnlyException(String msg, RID resourceID, IPropertyName propertyName) {
    super(msg, resourceID, propertyName);
  }
}
