/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Raised when a property name was too long. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: PropertyNameTooLongException.java,v 1.1 2002/11/07 16:26:11 jre
 *      Exp $
 */
public class PropertyNameTooLongException extends IllegalPropertyNameException {

  private int nameMax, namespaceMax;

  public PropertyNameTooLongException(String message, RID rid,
    String namespace, String name, int namespaceMax, int nameMax) {
    super(message, rid, namespace, name);
    this.nameMax = nameMax;
    this.namespaceMax = namespaceMax;
  }

  /**
   * @return maximum length for name (or <code>0</code> when unknown)
   */
  public int getNameMax() {
    return this.nameMax;
  }

  /**
   * @return maximum length for namespace name (or <code>0</code> when unknown)
   */
  public int getNamespaceMax() {
    return this.namespaceMax;
  }

}
