/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.*;

/**
 * This interface defines a list of <code>IPropertyNameList</code> objects.
 */
public class PropertyNameList implements IPropertyNameList {

  private List m_list;

  /**
   * Construct object of class PropertyNameList.
   */
  public PropertyNameList() {
    m_list = new ArrayList();
  }
  
  /**
   * Constructor for RF internal use.
   */
  PropertyNameList(List l) {
    this.m_list = l;    
  }

  /**
   * Returns the positioning object with the specified index
   *
   * @param index
   * @return TBD: Description of the outgoing return value
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public IPropertyName get(int index) {
    return (IPropertyName)m_list.get(index);
  }

  /**
   * Returns the number of positioning objects in the list
   *
   * @return TBD: Description of the outgoing return value
   * @todo: Description of the outgoing return value
   */
  public int size() {
    return m_list.size();
  }

  /**
   * Appends the specified positioning object to the end of the list
   *
   * @param name
   * @return TBD: Description of the outgoing return value
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public boolean add(IPropertyName name) {
    return m_list.add(name);
  }

  /**
   * Inserts the specified positioning object at the specified position in the
   * list
   *
   * @param index
   * @param name
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  public void add(int index, IPropertyName name) {
    m_list.add(index, name);
  }

  /**
   * @param propertyName
   * @return
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public boolean contains(IPropertyName propertyName) {
    return m_list.contains(propertyName);
  }

  /**
   * Returns a list iterator
   *
   * @return TBD: Description of the outgoing return value
   * @todo: Description of the outgoing return value
   */
  public IPropertyNameListIterator listIterator() {
    return new PropertyNameListIterator(m_list.listIterator());
  }

  /**
   * Returns the property list as a <code>List</code>
   *
   * @return the <code>IPropertyNameList</code> as a <code>List</code>
   */
  public List toList() {
    return m_list;
  }

  public void sort(Comparator c) {
    Collections.sort(this.m_list, c);
  }

  public String toString() {
    return this.m_list.toString();
  }

  // for RF intenal use

  IPropertyNameList l;

  public IPropertyNameList getListWithoutSystemPropertyNames() {
    return this.l;
  }

  void setListWithoutSystemPropertyNames(IPropertyNameList l) {
    this.l = l;
  }
}
