/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.IWcmConst;
import com.sapportals.wcm.util.name.Name;

/**
 * The name of a resource's property. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sap.com
 * @version $Revision: 1.17 $
 */
public class PropertyName extends Name implements IPropertyName, java.io.Serializable{

  /**
   * Construct a new name.
   *
   * @param namespace The namespace string
   * @param name The name of the property. It must not contains whiltespaces and
   *      must not start with a digit ('0'...'9') character.
   * @exception ResourceException If the property name is invalid
   */
  public PropertyName(String namespace, String name)
    throws ResourceException {
    super(namespace, name);

    if (name == null) {
      throw new IllegalPropertyNameException("Property name is null", null, namespace, name);
    }
    else if (name.length() == 0) {
      throw new IllegalPropertyNameException("Property name is empty", null, namespace, name);
    }
    else if (name.indexOf(' ') > -1) {
      throw new IllegalPropertyNameException("Whitespace characters are not allowed in property names", null, namespace, name);
    }
    else if (Character.isDigit(name.charAt(0))) {
      throw new IllegalPropertyNameException("Property name must not start with a digit character", null, namespace, name);
    }
  }

  /**
   * Constructs a new name from a {@link Name} instance.
   *
   * @param name TBD: Description of the incoming method parameter
   * @exception ResourceException Exception raised in failure situation
   */
  public PropertyName(Name name)
    throws ResourceException {
    this(name.getNamespace(), name.getName());
  }

  //////////////////////////////////////////////////////////////////////////////
  // static
  //////////////////////////////////////////////////////////////////////////////

  private static IPropertyName g_versioned = null;
  private static IPropertyName g_createdby = null;
  private static IPropertyName g_lastmodifiedby = null;
  private static IPropertyName g_creationdate = null;
  private static IPropertyName g_hidden = null;
  private static IPropertyName g_modified = null;
  private static IPropertyName g_description = null;
  private static IPropertyName g_displayname = null;
  private static IPropertyName g_readonly = null;
  private static IPropertyName g_length = null;
  private static IPropertyName g_type = null;
  private static IPropertyName g_etag = null;
  private static IPropertyName g_enhancedcoll = null;
  private static IPropertyName g_contentlanguage = null;
  private static IPropertyName g_resourcetype = null;
  private static IPropertyName g_collection = null;
  private static IPropertyName g_linktype = null;
  private static IPropertyName g_extension = null;

  public static IPropertyName createVersioned() {
    if (g_versioned == null) {
      try {
        g_versioned = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_VERSIONED);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property name: " + ex.getMessage());
      }
    }
    return g_versioned;
  }

  public static IPropertyName createCreatedBy() {
    if (g_createdby == null) {
      try {
        g_createdby = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_CREATEDBY);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_createdby;
  }

  public static IPropertyName createLastModifiedBy() {
    if (g_lastmodifiedby == null) {
      try {
        g_lastmodifiedby = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_LASTMODIFIEDBY);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_lastmodifiedby;
  }

  public static IPropertyName createCreationDate() {
    if (g_creationdate == null) {
      try {
        g_creationdate = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_CREATIONDATE);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_creationdate;
  }

  public static IPropertyName createHidden() {
    if (g_hidden == null) {
      try {
        g_hidden = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_HIDDEN);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_hidden;
  }
  
  public static IPropertyName createExtension() {
    if (g_extension == null) {
      try {
         g_extension = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_EXTENSION);
       }
       catch (ResourceException ex) {
         throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
   }
   return g_extension;
  }

  public static IPropertyName createLastModified() {
    if (g_modified == null) {
      try {
        g_modified = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_LASTMODIFIED);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_modified;
  }

  public static IPropertyName createDescription() {
    if (g_description == null) {
      try {
        g_description = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_DESCRIPTION);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_description;
  }

  public static IPropertyName createDisplayname() {
    if (g_displayname == null) {
      try {
        g_displayname = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_DISPLAYNAME);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_displayname;
  }

  public static IPropertyName createReadOnly() {
    if (g_readonly == null) {
      try {
        g_readonly = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_READONLY);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_readonly;
  }

  public static IPropertyName createContentLength() {
    if (g_length == null) {
      try {
        g_length = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_CONTENTLENGTH);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_length;
  }

  public static IPropertyName createContentType() {
    if (g_type == null) {
      try {
        g_type = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_CONTENTTYPE);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_type;
  }

  public static IPropertyName createETag() {
    if (g_etag == null) {
      try {
        g_etag = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_ETAG);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_etag;
  }

  public static IPropertyName createEnhancedCollection() {
    if (g_enhancedcoll == null) {
      try {
        g_enhancedcoll = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_ENHANCED_COLLECTION);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_enhancedcoll;
  }

  public static IPropertyName createContentLanguage() {
    if (g_contentlanguage == null) {
      try {
        g_contentlanguage = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_CONTENT_LANGUAGE);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_contentlanguage;
  }

  public static IPropertyName createResourceType() {
    if (g_resourcetype == null) {
      try {
        g_resourcetype = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_RESOURCE_TYPE);
      }
      catch (ResourceException ex) {
        throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
      }
    }
    return g_resourcetype;
  }
  
     public static IPropertyName createCollection() {
       if (g_collection == null) {
         try {
           g_collection = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_COLLECTION);
         }
         catch (ResourceException ex) {
           throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
         }
       }
       return g_collection;
     }
   
     public static IPropertyName createLinkType() {
       if (g_linktype == null) {
         try {
           g_linktype = new PropertyName(IWcmConst.SAP_WCM_NAMESPACE, IWcmConst.PROP_LINKTYPE);
         }
         catch (ResourceException ex) {
           throw new java.lang.RuntimeException("Exception creating property definition: " + ex.getMessage());
         }
       }
       return g_linktype;
     }  
}

